/*
 * Decompiled with CFR 0.152.
 */
package icad.view;

import icad.DAO.UtilisateurDAO;
import icad.model.Utilisateur;
import icad.view.ActionUser;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.table.DefaultTableModel;

public class MainFrame
extends JFrame {
    private List<Utilisateur> utilisateurs = new ArrayList<Utilisateur>();
    private JButton btnAddUser;
    private JButton btnDelUser;
    private JButton btnModifUser;
    private JScrollPane jScrollPane1;
    private JLabel labListUser;
    private JTable tabListUser;

    public MainFrame() {
        this.initComponents();
        DefaultTableModel tblUserModel = new DefaultTableModel(null, new String[]{"Nom", "Pr\u00e9nom", "Email", "Tel", "Adresse", "Ville", "Code Postal", "Fonction"}){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.tabListUser.setModel(tblUserModel);
        this.updateUI();
    }

    public void updateUI() {
        try {
            DefaultTableModel tblUserModel = (DefaultTableModel)this.tabListUser.getModel();
            UtilisateurDAO utilisateurDao = new UtilisateurDAO();
            this.utilisateurs = utilisateurDao.getAll();
            tblUserModel.setRowCount(0);
            for (Utilisateur utilisateur : this.utilisateurs) {
                tblUserModel.addRow(new Object[]{utilisateur.getNOM_UTILISATEUR(), utilisateur.getPRENOM_UTILISATEUR(), utilisateur.getEMAIL_UTILISATEUR(), utilisateur.getNO_TEL_UTILISATEUR(), utilisateur.getADRESSE_UTILISATEUR(), utilisateur.getVILLE_UTILISATEUR(), utilisateur.getCP_UTILISATEUR(), utilisateur.getFONCTION_UTILISATEUR()});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.btnAddUser = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.tabListUser = new JTable();
        this.btnModifUser = new JButton();
        this.btnDelUser = new JButton();
        this.labListUser = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setTitle("Page Principale");
        this.btnAddUser.setText("Ajouter un Utilisateur");
        this.btnAddUser.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                MainFrame.this.btnAddUserMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                MainFrame.this.btnAddUserMouseExited(evt);
            }
        });
        this.btnAddUser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.btnAddUserActionPerformed(evt);
            }
        });
        this.tabListUser.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPane1.setViewportView(this.tabListUser);
        this.btnModifUser.setText("Modifier un Utilisateur");
        this.btnModifUser.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                MainFrame.this.btnModifUserMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                MainFrame.this.btnModifUserMouseExited(evt);
            }
        });
        this.btnModifUser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.btnModifUserActionPerformed(evt);
            }
        });
        this.btnDelUser.setText("Supprimer un Utilisateur");
        this.btnDelUser.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                MainFrame.this.btnDelUserMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                MainFrame.this.btnDelUserMouseExited(evt);
            }
        });
        this.btnDelUser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.btnDelUserActionPerformed(evt);
            }
        });
        this.labListUser.setFont(new Font("Dialog", 0, 36));
        this.labListUser.setHorizontalAlignment(0);
        this.labListUser.setText("Liste des Utilisateurs");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(68, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addComponent(this.btnAddUser, -2, 163, -2).addGap(82, 82, 82).addComponent(this.btnModifUser, -2, 166, -2).addGap(77, 77, 77).addComponent(this.btnDelUser, -2, 178, -2))).addGap(66, 66, 66)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.labListUser).addGap(225, 225, 225)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(56, 56, 56).addComponent(this.labListUser).addGap(38, 38, 38).addComponent(this.jScrollPane1, -2, 365, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnAddUser, -2, 63, -2).addComponent(this.btnModifUser, -2, 63, -2).addComponent(this.btnDelUser, -2, 63, -2)).addContainerGap(13, Short.MAX_VALUE)));
        this.pack();
    }

    private void btnModifUserActionPerformed(ActionEvent evt) {
        try {
            System.out.println("btnModifUserActionPerformed: MARCHE");
            int row = this.tabListUser.getSelectedRow();
            Object[] options = new String[]{"Valider", "Annuler"};
            ActionUser actionUser = new ActionUser();
            actionUser.setTitre("Modifier un utilisateur");
            DefaultTableModel model = (DefaultTableModel)this.tabListUser.getModel();
            actionUser.setNomUser(model.getValueAt(row, 0).toString());
            actionUser.setPrenomUser(model.getValueAt(row, 1).toString());
            actionUser.setEmailUser(model.getValueAt(row, 2).toString());
            actionUser.setTelUser(model.getValueAt(row, 3).toString());
            actionUser.setAdresseUser(model.getValueAt(row, 4).toString());
            actionUser.setVilleUser(model.getValueAt(row, 5).toString());
            actionUser.setCPUser(model.getValueAt(row, 6).toString());
            actionUser.setProfessionUser(model.getValueAt(row, 7).toString());
            int result = JOptionPane.showOptionDialog(null, actionUser, "Modifier un utilisateur", 2, -1, null, options, options[0]);
            UtilisateurDAO modifUser = new UtilisateurDAO();
            if (result == 0) {
                Utilisateur user = new Utilisateur(actionUser.getIdUser(), actionUser.getEmailUser(), actionUser.getTelUser(), actionUser.getNomUser(), actionUser.getPrenomUser(), actionUser.getVilleUser(), actionUser.getAdresseUser(), actionUser.getCPUser(), actionUser.getProfessionUser(), actionUser.getMDPUser());
                for (int i = this.tabListUser.getSelectedRows().length - 1; i >= 0; --i) {
                    int idUtilisateur = this.utilisateurs.get(this.tabListUser.getSelectedRows()[i]).getID_UTILISATEUR();
                    user.setID_UTILISATEUR(idUtilisateur);
                }
                modifUser.update(user);
                this.updateUI();
            }
        }
        catch (Exception ex) {
            System.out.println("btnModifUserActionPerformed / RATE CASSE");
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void btnAddUserMouseEntered(MouseEvent evt) {
        this.btnAddUser.setBackground(new Color(151, 151, 151));
    }

    private void btnAddUserMouseExited(MouseEvent evt) {
        this.btnAddUser.setBackground(new Color(204, 204, 204));
    }

    private void btnModifUserMouseEntered(MouseEvent evt) {
        this.btnModifUser.setBackground(new Color(151, 151, 151));
    }

    private void btnModifUserMouseExited(MouseEvent evt) {
        this.btnModifUser.setBackground(new Color(204, 204, 204));
    }

    private void btnDelUserMouseEntered(MouseEvent evt) {
        this.btnDelUser.setBackground(new Color(151, 151, 151));
    }

    private void btnDelUserMouseExited(MouseEvent evt) {
        this.btnDelUser.setBackground(new Color(204, 204, 204));
    }

    private void btnAddUserActionPerformed(ActionEvent evt) {
        try {
            Object[] options = new String[]{"Valider", "Annuler"};
            ActionUser actionUser = new ActionUser();
            actionUser.setTitre("Cr\u00e9er un utilisateur");
            int result = JOptionPane.showOptionDialog(null, actionUser, "Ajouter un utilisateur", 2, -1, null, options, options[0]);
            UtilisateurDAO addUser = new UtilisateurDAO();
            if (result == 0) {
                Utilisateur user = new Utilisateur(actionUser.getEmailUser(), actionUser.getTelUser(), actionUser.getNomUser(), actionUser.getPrenomUser(), actionUser.getVilleUser(), actionUser.getAdresseUser(), actionUser.getCPUser(), actionUser.getProfessionUser(), actionUser.getMDPUser());
                addUser.create(user);
                this.updateUI();
            }
        }
        catch (Exception ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void btnDelUserActionPerformed(ActionEvent evt) {
        try {
            int[] selectedRows = this.tabListUser.getSelectedRows();
            if (selectedRows.length == 0) {
                JOptionPane.showMessageDialog(this, "Veuillez s\u00e9lectionner au moins un utilisateur \u00e0 supprimer.", "Aucune s\u00e9lection", 2);
                return;
            }
            int option = JOptionPane.showConfirmDialog(this, "Voulez-vous supprimer les utilisateurs s\u00e9lectionn\u00e9s ?", "Confirmation de suppression", 0);
            if (option == 0) {
                for (int i = selectedRows.length - 1; i >= 0; --i) {
                    int idUtilisateur = this.utilisateurs.get(selectedRows[i]).getID_UTILISATEUR();
                    System.out.println(idUtilisateur);
                    UtilisateurDAO utilisateurDAO = new UtilisateurDAO();
                    utilisateurDAO.delete(idUtilisateur);
                    this.updateUI();
                }
                JOptionPane.showMessageDialog(this, "Utilisateurs supprim\u00e9s avec succ\u00e8s.", "Suppression r\u00e9ussie", 1);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
            JOptionPane.showMessageDialog(this, "Une erreur s'est produite lors de la suppression des utilisateurs.", "Erreur", 0);
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MainFrame().setVisible(true);
            }
        });
    }
}

